<?php
/*
Plugin Name: Quảng cáo TVC
Description: Plugin chèn video quảng cáo dành cho website phim được xây dựng bởi Crawl.Team
Version: 1.5
Author: Crawl.Team
*/
// Tạo menu quản lý trong admin
function crawl_team_ad_video_player_menu() {
    add_options_page('Cài đặt quảng cáo TVC', 'Quảng cáo TVC', 'manage_options', 'ad-video-player', 'crawl_team_ad_video_player_settings_page');
}
add_action('admin_menu', 'crawl_team_ad_video_player_menu');
// Đăng ký cài đặt
function crawl_team_ad_video_player_settings() {
    register_setting('crawl_team_ad_video_player_settings_group', 'ad_video_enabled');
    register_setting('crawl_team_ad_video_player_settings_group', 'ad_video_url');
    register_setting('crawl_team_ad_video_player_settings_group', 'ad_redirect_url');
    register_setting('crawl_team_ad_video_player_settings_group', 'ad_duration');
}
add_action('admin_init', 'crawl_team_ad_video_player_settings');
// Giao diện trang cài đặt
function crawl_team_ad_video_player_settings_page() {
    ?>
    <div class="wrap">
        <h1>Cài đặt quảng cáo TVC</h1>
        <p>Plugin chèn video quảng cáo cho website phim được xây dựng bởi <a href="https://crawl.team/" target="_blank">Crawl.Team</a></p>
        <form method="post" action="options.php">
            <?php settings_fields('crawl_team_ad_video_player_settings_group'); ?>
            <?php do_settings_sections('crawl_team_ad_video_player_settings_group'); ?>
            <table class="form-table">
                <tr>
                    <th><label for="ad_video_enabled">Bật quảng cáo:</label></th>
                    <td><input type="checkbox" id="ad_video_enabled" name="ad_video_enabled" value="1" <?php checked(1, get_option('ad_video_enabled')); ?> /></td>
                </tr>
                <tr>
                    <th><label for="ad_video_url">Link video quảng cáo (MP4):</label></th>
                    <td><input type="url" id="ad_video_url" placeholder="https://crawl.team/ads.mp4" name="ad_video_url" value="<?php echo esc_attr(get_option('ad_video_url')); ?>" class="regular-text" /></td>
                </tr>
                <tr>
                    <th><label for="ad_redirect_url">Link điều hướng khi nhấp vào quảng cáo:</label></th>
                    <td><input type="url" id="ad_redirect_url" name="ad_redirect_url" placeholder="https://crawl.team/compain?v=36587" value="<?php echo esc_attr(get_option('ad_redirect_url')); ?>" class="regular-text" /></td>
                </tr>
                <tr>
                    <th><label for="ad_duration">Thời gian quảng cáo (giây):</label></th>
                    <td><input type="number" id="ad_duration" name="ad_duration" placeholder="5" value="<?php echo esc_attr(get_option('ad_duration', 5)); ?>" min="1" class="regular-text" /></td>
                </tr>
            </table>
            <?php submit_button(); ?>
        </form>
    </div>
    <?php
}
// Đăng ký script và style
function crawl_team_ad_video_player_scripts() {
    if (get_option('ad_video_enabled') && get_option('ad_video_url')) {
        wp_enqueue_script('ad-video-player', plugin_dir_url(__FILE__) . 'js/ad-video-player.js', array('jquery'), '1.5', true);
        wp_enqueue_style('ad-video-player', plugin_dir_url(__FILE__) . 'css/ad-video-player.css');
        wp_localize_script('ad-video-player', 'adVideoSettings', array(
            'adVideoUrl' => get_option('ad_video_url'),
            'adRedirectUrl' => get_option('ad_redirect_url'),
            'pluginUrl' => plugin_dir_url(__FILE__),
            'adDuration' => get_option('ad_duration', 5)
        ));
    }
}
add_action('wp_enqueue_scripts', 'crawl_team_ad_video_player_scripts');