<?php 
function add_custom_post_meta_box() {
    add_meta_box(
        'custom_post_meta_box',
        'Thông tin bổ sung',
        'render_custom_post_meta_box',
        'post',
        'normal',
        'high'
    );
}
add_action('add_meta_boxes', 'add_custom_post_meta_box');

function render_custom_post_meta_box($post) {
    $post_quality = get_post_meta($post->ID, '_post_quality', true);
    $post_code = get_post_meta($post->ID, '_post_code', true);
    $post_play = get_post_meta($post->ID, '_post_play', true);
    wp_nonce_field('custom_post_meta_nonce', 'custom_post_meta_nonce_field');
    ?>
    <p style="width: 49%; margin: 0;display: inline-block;">
        <label for="post_quality">Chất lượng</label><br>
        <input type="text" id="post_quality" name="post_quality" value="<?php echo esc_attr($post_quality); ?>" style="width: 100%;">
    </p>
    <p style="width: 49%; margin: 0;display: inline-block;">
        <label for="post_code">Code video</label><br>
        <input type="text" id="post_code" name="post_code" value="<?php echo esc_attr($post_code); ?>" style="width: 100%;">
    </p>
    <p>
        <label for="post_play">Link phát</label><br>
        <input type="text" id="post_play" name="post_play" value="<?php echo esc_attr($post_play); ?>" style="width: 100%;">
    </p>
    <?php
}

function save_custom_post_meta($post_id) {
    if (!isset($_POST['custom_post_meta_nonce_field']) || !wp_verify_nonce($_POST['custom_post_meta_nonce_field'], 'custom_post_meta_nonce')) {
        return;
    }
    if (!current_user_can('edit_post', $post_id)) {
        return;
    }
    if (isset($_POST['post_quality'])) {
        update_post_meta($post_id, '_post_quality', sanitize_text_field($_POST['post_quality']));
    }
    if (isset($_POST['post_code'])) {
        update_post_meta($post_id, '_post_code', sanitize_text_field($_POST['post_code']));
    }
    if (isset($_POST['post_play'])) {
        update_post_meta($post_id, '_post_play', sanitize_text_field($_POST['post_play']));
    }
}
add_action('save_post', 'save_custom_post_meta');
 ?>