<?php 
function crawl_team_create_search_keywords_table() {
    global $wpdb;
    $table_name = $wpdb->prefix . 'search_keywords';
    $charset_collate = $wpdb->get_charset_collate();

    // Tạo SQL tạo bảng
    $sql = "CREATE TABLE IF NOT EXISTS $table_name (
        id BIGINT(20) UNSIGNED NOT NULL AUTO_INCREMENT,
        keyword VARCHAR(255) NOT NULL,
        count BIGINT(20) UNSIGNED NOT NULL DEFAULT 1,
        PRIMARY KEY (id),
        UNIQUE KEY (keyword)
    ) $charset_collate;";

    require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
    dbDelta($sql);
}

add_action('after_setup_theme', 'crawl_team_create_search_keywords_table');


function crawl_team_store_search_keywords_in_db() {
    if (is_search() && !empty(get_search_query())) {
        global $wpdb;
        $table_name = $wpdb->prefix . 'search_keywords';
        $search_query = sanitize_text_field(get_search_query());

        $existing_keyword = $wpdb->get_row($wpdb->prepare("SELECT * FROM $table_name WHERE keyword = %s", $search_query));

        if ($existing_keyword) {
            $wpdb->update(
                $table_name,
                ['count' => $existing_keyword->count + 1],
                ['keyword' => $search_query]
            );
        } else {
            $wpdb->insert(
                $table_name,
                ['keyword' => $search_query, 'count' => 1]
            );
        }
    }
}
add_action('template_redirect', 'crawl_team_store_search_keywords_in_db');
 ?>