<?php
function crawl_team_modify_query($clauses, $query) {
    if ($query->is_search() && !is_admin() && $query->is_main_query()) {
        global $wpdb;

        $search_keyword = sanitize_text_field($query->get('s'));
        $search_keyword_decoded = urldecode($search_keyword);

        $remove_accents = function ($str) {
            $unwanted_array = [
                'Á'=>'A','À'=>'A','Ả'=>'A','Ã'=>'A','Ạ'=>'A','Ă'=>'A','Ắ'=>'A','Ằ'=>'A','Ẳ'=>'A','Ẵ'=>'A','Ặ'=>'A',
                'Â'=>'A','Ấ'=>'A','Ầ'=>'A','Ẩ'=>'A','Ẫ'=>'A','Ậ'=>'A','á'=>'a','à'=>'a','ả'=>'a','ã'=>'a','ạ'=>'a',
                'ă'=>'a','ắ'=>'a','ằ'=>'a','ẳ'=>'a','ẵ'=>'a','ặ'=>'a','â'=>'a','ấ'=>'a','ầ'=>'a','ẩ'=>'a','ẫ'=>'a',
                'ậ'=>'a','É'=>'E','È'=>'E','Ẻ'=>'E','Ẽ'=>'E','Ẹ'=>'E','Ê'=>'E','Ế'=>'E','Ề'=>'E','Ể'=>'E','Ễ'=>'E',
                'Ệ'=>'E','é'=>'e','è'=>'e','ẻ'=>'e','ẽ'=>'e','ẹ'=>'e','ê'=>'e','ế'=>'e','ề'=>'e','ể'=>'e','ễ'=>'e',
                'ệ'=>'e','Í'=>'I','Ì'=>'I','Ỉ'=>'I','Ĩ'=>'I','Ị'=>'I','í'=>'i','ì'=>'i','ỉ'=>'i','ĩ'=>'i','ị'=>'i',
                'Ó'=>'O','Ò'=>'O','Ỏ'=>'O','Õ'=>'O','Ọ'=>'O','Ô'=>'O','Ố'=>'O','Ồ'=>'O','Ổ'=>'O','Ỗ'=>'O','Ộ'=>'O',
                'Ơ'=>'O','Ớ'=>'O','Ờ'=>'O','Ở'=>'O','Ỡ'=>'O','Ợ'=>'O','ó'=>'o','ò'=>'o','ỏ'=>'o','õ'=>'o','ọ'=>'o',
                'ô'=>'o','ố'=>'o','ồ'=>'o','ổ'=>'o','ỗ'=>'o','ộ'=>'o','ơ'=>'o','ớ'=>'o','ờ'=>'o','ở'=>'o','ỡ'=>'o',
                'ợ'=>'o','Ú'=>'U','Ù'=>'U','Ủ'=>'U','Ũ'=>'U','Ụ'=>'U','Ư'=>'U','Ứ'=>'U','Ừ'=>'U','Ử'=>'U','Ữ'=>'U',
                'Ự'=>'U','ú'=>'u','ù'=>'u','ủ'=>'u','ũ'=>'u','ụ'=>'u','ư'=>'u','ứ'=>'u','ừ'=>'u','ử'=>'u','ữ'=>'u',
                'ự'=>'u','Ý'=>'Y','Ỳ'=>'Y','Ỷ'=>'Y','Ỹ'=>'Y','Ỵ'=>'Y','ý'=>'y','ỳ'=>'y','ỷ'=>'y','ỹ'=>'y','ỵ'=>'y',
                'Đ'=>'D','đ'=>'d'
            ];
            return strtr($str, $unwanted_array);
        };

        $search_keyword_no_accents = $remove_accents($search_keyword_decoded);

        $taxonomies = array('post_tag', 'actor', 'category', 'code');
        $post_ids = array();

        foreach ($taxonomies as $taxonomy) {
            $term_ids = $wpdb->get_col(
                $wpdb->prepare(
                    "SELECT term_id FROM {$wpdb->terms} 
                     WHERE LOWER(REPLACE(name, '-', '')) LIKE LOWER(REPLACE(%s, '-', ''))",
                    '%' . $wpdb->esc_like($search_keyword_no_accents) . '%'
                )
            );

            if (!empty($term_ids)) {
                $taxonomy_post_ids = $wpdb->get_col(
                    "SELECT object_id FROM {$wpdb->term_relationships} tr
                     INNER JOIN {$wpdb->term_taxonomy} tt ON tr.term_taxonomy_id = tt.term_taxonomy_id
                     WHERE tt.taxonomy = '{$taxonomy}' AND tt.term_id IN (" . implode(',', $term_ids) . ")"
                );

                $post_ids = array_merge($post_ids, $taxonomy_post_ids);
            }
        }

        if (!empty($post_ids)) {
            $clauses['where'] .= " OR {$wpdb->posts}.ID IN (" . implode(',', array_unique($post_ids)) . ")";
        }
    }

    return $clauses;
}
add_filter('posts_clauses', 'crawl_team_modify_query', 10, 2);