<?php 
	add_action('wp_ajax_load_more_related_posts', 'load_more_related_posts_callback');
	add_action('wp_ajax_nopriv_load_more_related_posts', 'load_more_related_posts_callback');

	function load_more_related_posts_callback() {
	    // Xác minh nonce để bảo mật
	    if (!check_ajax_referer('load_more_related_posts_nonce', 'nonce', false)) {
	        wp_send_json_error('Invalid nonce');
	        wp_die();
	    }

	    $category_ids = isset($_POST['category_ids']) ? json_decode(stripslashes($_POST['category_ids']), true) : array();
	    $category_ids = array_map('intval', (array)$category_ids);
	    $exclude_post = isset($_POST['exclude_post']) ? intval($_POST['exclude_post']) : 0;
	    $page = isset($_POST['page']) ? intval($_POST['page']) : 1;
	    $posts_per_page = isset($_POST['posts_per_page']) ? intval($_POST['posts_per_page']) : 8;

	    $args = array(
	        'category__in' => $category_ids,
	        'post__not_in' => array($exclude_post),
	        'posts_per_page' => $posts_per_page,
	        'paged' => $page,
	        'orderby' => 'rand',
	    );

	    $related_posts = new WP_Query($args);
	    $output = '';

	    if ($related_posts->have_posts()) {
	        while ($related_posts->have_posts()) : $related_posts->the_post();
	            ob_start();
	            $post_quality = get_post_meta( get_the_ID(), '_post_quality', true );
	            ?>
	            <div class="col post-item">
	                <div class="col-inner">
	                    <div class="box box-normal box-text-bottom box-blog-post has-hover">
	                    	<?php  if (!empty($post_quality)) { ?>
                    			<span class="post_quality"><?php echo $post_quality; ?></span>
                    		<?php } ?>
	                        <div class="box-image" style="border-radius:1%;">
	                            <div class="image-cover" style="padding-top:56%;">
	                                <a href="<?php the_permalink(); ?>" class="plain" aria-label="<?php the_title(); ?>">
	                                    <?php if (has_post_thumbnail()) : ?>
	                                        <img decoding="async" src="<?php echo get_the_post_thumbnail_url(get_the_ID(), 'medium'); ?>" class="attachment-medium size-medium wp-post-image" alt="<?php the_title(); ?>">
	                                    <?php endif; ?>
	                                </a>
	                            </div>
	                        </div>
	                        <div class="box-text text-left is-small dark">
	                            <div class="box-text-inner blog-post-inner">
	                                <h5 class="post-title is-large">
	                                    <a href="<?php the_permalink(); ?>" class="plain"><?php the_title(); ?></a>
	                                </h5>
	                            </div>
	                        </div>
	                    </div>
	                </div>
	            </div>
	            <?php
	            $output .= ob_get_clean();
	        endwhile;
	    }

	    wp_reset_postdata();
	    wp_send_json_success(array(
	        'posts' => $output,
	        'has_more' => $related_posts->max_num_pages > $page
	    ));
	    wp_die();
	}

?>