<?php 
function register_actor_taxonomy() {
    $labels = array(
        'name'              => 'Diễn viên',
        'singular_name'     => 'Diễn viên',
        'search_items'      => 'Tìm kiếm Diễn viên',
        'all_items'         => 'Tất cả Diễn viên',
        'edit_item'         => 'Sửa Diễn viên',
        'update_item'       => 'Cập nhật Diễn viên',
        'add_new_item'      => 'Thêm Diễn viên mới',
        'new_item_name'     => 'Tên Diễn viên mới',
        'menu_name'         => 'Diễn viên',
    );

    $args = array(
        'hierarchical'      => false,
        'labels'            => $labels,
        'show_ui'           => true,
        'show_admin_column' => true,
        'query_var'         => true,
        'rewrite'           => array('slug' => 'dien-vien'),
    );

    register_taxonomy('actor', array('post'), $args);
}
add_action('init', 'register_actor_taxonomy');


function register_director_taxonomy() {
    $labels = array(
        'name'              => 'Đạo diễn',
        'singular_name'     => 'Đạo diễn',
        'search_items'      => 'Tìm kiếm Đạo diễn',
        'all_items'         => 'Tất cả Đạo diễn',
        'edit_item'         => 'Sửa Đạo diễn',
        'update_item'       => 'Cập nhật Đạo diễn',
        'add_new_item'      => 'Thêm Đạo diễn mới',
        'new_item_name'     => 'Tên Đạo diễn mới',
        'menu_name'         => 'Đạo diễn',
    );

    $args = array(
        'hierarchical'      => false,
        'labels'            => $labels,
        'show_ui'           => true,
        'show_admin_column' => true,
        'query_var'         => true,
        'rewrite'           => array('slug' => 'dao-dien'),
    );

    register_taxonomy('director', array('post'), $args);
}
add_action('init', 'register_director_taxonomy');


function register_country_taxonomy() {
    $labels = array(
        'name'              => 'Quốc gia',
        'singular_name'     => 'Quốc gia',
        'search_items'      => 'Tìm kiếm Quốc gia',
        'all_items'         => 'Tất cả Quốc gia',
        'edit_item'         => 'Sửa Quốc gia',
        'update_item'       => 'Cập nhật Quốc gia',
        'add_new_item'      => 'Thêm Quốc gia mới',
        'new_item_name'     => 'Tên Quốc gia mới',
        'menu_name'         => 'Quốc gia',
    );

    $args = array(
        'hierarchical'      => false,
        'labels'            => $labels,
        'show_ui'           => true,
        'show_admin_column' => true,
        'query_var'         => true,
        'rewrite'           => array('slug' => 'quoc-gia'),
    );

    register_taxonomy('country', array('post'), $args);
}
add_action('init', 'register_country_taxonomy');


function register_code_taxonomy() {
    $labels = array(
        'name'              => 'Code',
        'singular_name'     => 'Code',
        'search_items'      => 'Tìm kiếm Code',
        'all_items'         => 'Tất cả Code',
        'edit_item'         => 'Sửa Code',
        'update_item'       => 'Cập nhật Code',
        'add_new_item'      => 'Thêm Code mới',
        'new_item_name'     => 'Tên Code mới',
        'menu_name'         => 'Code',
    );

    $args = array(
        'hierarchical'      => false,
        'labels'            => $labels,
        'show_ui'           => true,
        'show_admin_column' => true,
        'query_var'         => true,
        'rewrite'           => array('slug' => 'code'),
    );

    register_taxonomy('code', array('post'), $args);
}
add_action('init', 'register_code_taxonomy');
 ?>