<?php
function crawl_team_set_post_views($postID) {
    $count_key = 'crawl_team_post_views_count';
    $timestamp_key = 'crawl_team_view_timestamps';
    
    if (!is_numeric($postID)) {
        return;
    }
    
    $count = get_post_meta($postID, $count_key, true);
    if ($count === '') {
        $count = 0;
        delete_post_meta($postID, $count_key);
        add_post_meta($postID, $count_key, '0');
    } else {
        $count++;
    }
    $result_count = update_post_meta($postID, $count_key, $count);
    
    $timestamps = get_post_meta($postID, $timestamp_key, true);
    if (!is_array($timestamps) || empty($timestamps)) {
        $timestamps = array();
    }
    $current_time = current_time('timestamp');
    $timestamps[] = $current_time;
    $result_timestamp = update_post_meta($postID, $timestamp_key, $timestamps);
    
}

function crawl_team_track_post_views($post_id) {
    error_log("is_single: " . (is_single() ? 'true' : 'false') . ", Post ID passed: " . ($post_id ? $post_id : 'none'));
    if (!is_single()) return;
    if (empty($post_id)) {
        global $post;
        if (isset($post->ID) && is_numeric($post->ID)) {
            $post_id = $post->ID;
        } else {
            return;
        }
    }
    crawl_team_set_post_views($post_id);
}
add_action('wp_head', 'crawl_team_track_post_views');

function crawl_team_get_post_views($postID) {
    $count_key = 'crawl_team_post_views_count';
    $count = get_post_meta($postID, $count_key, true);
    if ($count === '') {
        delete_post_meta($postID, $count_key);
        add_post_meta($postID, $count_key, '0');
        $count = '0';
    }
    if ($count === '0') {
        return '';
    }
    return '<span class="movie-views">👁 ' . $count . '</span>';
}

function crawl_team_post_views_shortcode() {
    global $post;
    return crawl_team_get_post_views($post->ID);
}
add_shortcode('post_views', 'crawl_team_post_views_shortcode');
?>