<?php
class Crawl_Team_Category_Widget extends WP_Widget {
    // Khởi tạo widget
    public function __construct() {
        parent::__construct(
            'Crawl_Team_Category_Widget', // ID widget
            __('[Crawl Team] Hiển thị danh mục phim', 'text_domain'), // Tên widget
            array('description' => __('Hiển thị danh sách danh mục kèm hình ảnh', 'text_domain')) // Mô tả
        );
    }

    // Hiển thị nội dung widget
    public function widget($args, $instance) {
        echo $args['before_widget'];
        // Lấy số lượng danh mục từ instance, mặc định là 4 nếu không có
        $number = !empty($instance['number']) ? absint($instance['number']) : 4;
        ?>
        <div class="crawl-team-categories-tag">
            <?php 
				if (!empty($instance['title'])) {
		            echo $args['before_title'] . apply_filters('widget_title', $instance['title']) . $args['after_title'];
		        }
             ?>
            <div class="row large-columns-4 medium-columns-1 small-columns-1 row-small">
                <?php
                $categories = get_categories(array(
                    'number' => $number, // Giới hạn số lượng danh mục
                    'hide_empty' => false, // Hiển thị cả danh mục rỗng
                ));
                if (!empty($categories)) {
                    foreach ($categories as $category) {
                        $image_id = get_term_meta($category->term_id, 'category-image-id', true);
                        ?>
                        <div class="col post-item">
                            <a href="<?php echo esc_url(get_category_link($category->term_id)); ?>">
                                <div class="categories-list-item">
                                    <div class="entry-image">
                                        <?php
                                        if ($image_id) {
                                            echo wp_get_attachment_image($image_id, 'thumbnail');
                                        } else {
                                            echo '<img src="' . get_template_directory_uri() . '/assets/img/default.png" class="no-image" alt="no-image" />';
                                        }
                                        ?>
                                    </div>
                                    <div class="entry-body">
                                        <?php echo esc_html($category->name); ?>
                                    </div>
                                </div>
                            </a>
                        </div>
                        <?php
                    }
                }
                ?>
            </div>
        </div>
        <?php
        echo $args['after_widget'];
    }

    // Form cấu hình widget
    public function form($instance) {
        $title = !empty($instance['title']) ? $instance['title'] : '';
        $number = !empty($instance['number']) ? $instance['number'] : 4; // Giá trị mặc định
        ?>
        <p>
            <label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Tiêu đề:', 'text_domain'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo esc_attr($title); ?>" />
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('number'); ?>"><?php _e('Số lượng danh mục:', 'text_domain'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('number'); ?>" name="<?php echo $this->get_field_name('number'); ?>" type="number" min="1" value="<?php echo esc_attr($number); ?>" />
        </p>
        <?php
    }

    // Cập nhật dữ liệu widget
    public function update($new_instance, $old_instance) {
        $instance = array();
        $instance['title'] = (!empty($new_instance['title'])) ? sanitize_text_field($new_instance['title']) : '';
        $instance['number'] = (!empty($new_instance['number']) && $new_instance['number'] > 0) ? absint($new_instance['number']) : 4; // Đảm bảo số dương
        return $instance;
    }
}

// Đăng ký widget
function register_Crawl_Team_Category_Widget() {
    register_widget('Crawl_Team_Category_Widget');
}
add_action('widgets_init', 'register_Crawl_Team_Category_Widget');
?>