<?php
// Hàm xử lý truy vấn bài viết
function crawl_team_get_top_posts($type = 'hot', $posts_per_page = 5) { // Giá trị mặc định là 5 nếu không được thiết lập
    $args = array(
        'post_type' => 'post',
        'posts_per_page' => $posts_per_page,
        'meta_key' => 'crawl_team_post_views_count',
        'orderby' => 'meta_value_num',
        'order' => 'DESC',
        'ignore_sticky_posts' => true,
    );

    if ($type === 'day' || $type === 'week') {
        $time_limit = ($type === 'day') ? strtotime('-1 day') : strtotime('-1 week');

        $all_posts = new WP_Query(array(
            'post_type' => 'post',
            'posts_per_page' => -1,
            'meta_key' => 'crawl_team_post_views_count',
            'fields' => 'ids',
        ));

        $filtered_posts = array();
        if ($all_posts->have_posts()) {
            while ($all_posts->have_posts()) {
                $all_posts->the_post();
                $post_id = get_the_ID();
                $timestamps = get_post_meta($post_id, 'crawl_team_view_timestamps', true);
                
                if (is_array($timestamps) && !empty($timestamps)) {
                    $recent_views = count(array_filter($timestamps, function($timestamp) use ($time_limit) {
                        return is_numeric($timestamp) && $timestamp >= $time_limit;
                    }));
                    
                    if ($recent_views > 0) {
                        $filtered_posts[$post_id] = $recent_views;
                    }
                }
            }
        }
        wp_reset_postdata();

        if (empty($filtered_posts)) {
            ob_start();
            echo '<p>Chưa có bài viết nào trong khoảng thời gian này.</p>';
            return ob_get_clean();
        }

        arsort($filtered_posts);
        $post_ids = array_slice(array_keys($filtered_posts), 0, $posts_per_page);
        $args['post__in'] = !empty($post_ids) ? $post_ids : array(0);
        $args['orderby'] = 'post__in';
    }

    $query = new WP_Query($args);
    ob_start();
    if ($query->have_posts()) {
        while ($query->have_posts()) {
            $query->the_post();
            $post_quality = get_post_meta( get_the_ID(), '_post_quality', true );
            ?>
            <div class="col post-item">
                <div class="col-inner">
                    <div class="box box-normal box-text-bottom box-blog-post has-hover">
                        <?php  if (!empty($post_quality)) { ?>
                                    <span class="post_quality"><?php echo $post_quality; ?></span>
                                <?php } ?>
                        <div class="box-image" style="border-radius:1%;">
                            <div class="image-cover" style="padding-top:56%;">
                                <a href="<?php the_permalink(); ?>" class="plain" aria-label="<?php the_title(); ?>">
                                    <?php if (has_post_thumbnail()) {
                                        the_post_thumbnail('medium', array('class' => 'attachment-medium size-medium wp-post-image', 'alt' => get_the_title()));
                                    } ?>
                                </a>
                            </div>
                        </div>
                        <div class="box-text text-left is-small dark">
                            <div class="box-text-inner blog-post-inner">
                                <h5 class="post-title is-large">
                                    <a href="<?php the_permalink(); ?>" class="plain"><?php the_title(); ?></a>
                                </h5>
                                <?php echo do_shortcode('[post_views]'); ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php
        }
    } else {
        echo '<p>Chưa có bài viết nào trong khoảng thời gian này.</p>';
    }
    wp_reset_postdata();
    return ob_get_clean();
}

// Xử lý AJAX
add_action('wp_ajax_crawl_team_load_top_posts', 'crawl_team_load_top_posts_callback');
add_action('wp_ajax_nopriv_crawl_team_load_top_posts', 'crawl_team_load_top_posts_callback');

function crawl_team_load_top_posts_callback() {
    $type = isset($_POST['type']) ? sanitize_text_field($_POST['type']) : 'hot';
    $posts_per_page = isset($_POST['posts_per_page']) ? absint($_POST['posts_per_page']) : 5; // Lấy từ AJAX
    echo crawl_team_get_top_posts($type, $posts_per_page);
    wp_die();
}

// Widget class
class Crawl_Team_Top_Posts_Widget extends WP_Widget {
    public function __construct() {
        parent::__construct(
            'crawl_team_top_posts_widget',
            '[Crawl Team] Hiển thị danh sách bài viết nổi bật',
            array('description' => 'Hiển thị danh sách bài viết theo lượt xem với các tab Đang HOT, TOP Ngày, TOP Tuần')
        );
    }

    public function widget($args, $instance) {
        echo $args['before_widget'];
        if (!empty($instance['title'])) {
            echo $args['before_title'] . apply_filters('widget_title', $instance['title']) . $args['after_title'];
        }

        $posts_per_page = !empty($instance['posts_per_page']) ? absint($instance['posts_per_page']) : 5; // Lấy từ cấu hình widget

        $output = '<div class="crawl-team-top-movies" data-posts-per-page="' . esc_attr($posts_per_page) . '">';
        $output .= '<div class="crawl-team-tab-panel">';
        $output .= '<span class="tab active" data-tab="hot">Đang HOT</span>';
        $output .= '<span class="tab" data-tab="day">TOP Ngày</span>';
        $output .= '<span class="tab" data-tab="week">TOP Tuần</span>';
        $output .= '</div>';
        $output .= '<div class="row large-columns-2 medium-columns-1 small-columns-1 row-small" id="top-movies-content">';
        $output .= crawl_team_get_top_posts('hot', $posts_per_page);
        $output .= '</div>';
        $output .= '</div>';
        echo $output;

        echo $args['after_widget'];
    }

    public function form($instance) {
        $title = !empty($instance['title']) ? $instance['title'] : '';
        $posts_per_page = !empty($instance['posts_per_page']) ? $instance['posts_per_page'] : 5; // Mặc định 5
        ?>
        <p>
            <label for="<?php echo $this->get_field_id('title'); ?>">Tiêu đề:</label>
            <input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo esc_attr($title); ?>">
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('posts_per_page'); ?>">Số bài viết hiển thị:</label>
            <input class="widefat" id="<?php echo $this->get_field_id('posts_per_page'); ?>" name="<?php echo $this->get_field_name('posts_per_page'); ?>" type="number" value="<?php echo esc_attr($posts_per_page); ?>" min="1">
        </p>
        <?php
    }

    public function update($new_instance, $old_instance) {
        $instance = array();
        $instance['title'] = !empty($new_instance['title']) ? sanitize_text_field($new_instance['title']) : '';
        $instance['posts_per_page'] = !empty($new_instance['posts_per_page']) ? absint($new_instance['posts_per_page']) : 5;
        return $instance;
    }
}

// Đăng ký widget
function crawl_team_register_top_posts_widget() {
    register_widget('Crawl_Team_Top_Posts_Widget');
}
add_action('widgets_init', 'crawl_team_register_top_posts_widget');

// JavaScript cho AJAX
add_action('wp_enqueue_scripts', function() {
    wp_enqueue_script('jquery');
    wp_add_inline_script('jquery', '
        jQuery(document).ready(function($) {
            $(".crawl-team-tab-panel .tab[data-tab=\'hot\']").addClass("active");
            
            $(".crawl-team-tab-panel .tab").click(function() {
                var type = $(this).data("tab");
                var posts_per_page = $(this).closest(".crawl-team-top-movies").data("posts-per-page") || 5;
                $(".crawl-team-tab-panel .tab").removeClass("active");
                $(this).addClass("active");
                
                $.ajax({
                    url: "' . admin_url('admin-ajax.php') . '",
                    type: "POST",
                    data: {
                        action: "crawl_team_load_top_posts",
                        type: type,
                        posts_per_page: posts_per_page
                    },
                    success: function(response) {
                        $("#top-movies-content").html(response);
                    }
                });
            });
        });
    ');
});
?>