<?php 
class Crawl_Team_Sidebar_Category_Widget extends WP_Widget {
    public function __construct() {
        parent::__construct(
            'crawl_team_sidebar_category_widget',
            '[Crawl Team] Hiển thị phim tại Sidebar',
            array('description' => 'Hiển thị bài viết từ danh mục được chọn')
        );
    }

    public function widget($args, $instance) {
        echo $args['before_widget'];
        if (!empty($instance['title'])) {
            echo "<h3>". $args['before_title'] . apply_filters('widget_title', $instance['title']) . $args['after_title'] ."</h3>";
        }

        $category = !empty($instance['category']) ? $instance['category'] : '';
        $post_count = !empty($instance['post_count']) ? $instance['post_count'] : 5;

        $posts = new WP_Query(array(
            'cat' => $category,
            'posts_per_page' => $post_count,
        ));

        if ($posts->have_posts()) {
            echo '<div class="row large-columns-2 medium-columns-1 small-columns-1 row-small">';
            while ($posts->have_posts()) {
                $posts->the_post();
                $post_quality = get_post_meta( get_the_ID(), '_post_quality', true ); ?>
                    <div class="col post-item">
                        <div class="col-inner">
                            <div class="box box-normal box-text-bottom box-blog-post has-hover">
                                <?php  if (!empty($post_quality)) { ?>
                                    <span class="post_quality"><?php echo $post_quality; ?></span>
                                <?php } ?>
                                <div class="box-image" style="border-radius:1%;">
                                    <div class="image-cover" style="padding-top:56%;">
                                        <a href="<?php the_permalink(); ?>" class="plain" aria-label="<?php the_title(); ?>">
                                            <img decoding="async" src="<?php the_post_thumbnail_url(); ?>" class="attachment-medium size-medium wp-post-image" alt="<?php the_title(); ?>"> </a>
                                    </div>
                                </div>
                                <div class="box-text text-left is-small dark">
                                    <div class="box-text-inner blog-post-inner">
                                        <h5 class="post-title is-large ">
                                            <a href="<?php the_permalink(); ?>" class="plain"><?php the_title(); ?></a>
                                        </h5>
                                    </div>
                                    <?php echo do_shortcode('[post_views]'); ?>
                                </div>
                            </div>
                        </div>
                    </div>
            <?php }
            echo '</div>';
            wp_reset_postdata();
        }

        echo $args['after_widget'];
    }

    public function form($instance) {
        $title = !empty($instance['title']) ? $instance['title'] : '';
        $category = !empty($instance['category']) ? $instance['category'] : '';
        $post_count = !empty($instance['post_count']) ? $instance['post_count'] : 5;
        ?>
        <p>
            <label for="<?php echo $this->get_field_id('title'); ?>">Tiêu đề:</label>
            <input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo esc_attr($title); ?>">
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('category'); ?>">Danh mục:</label>
            <select class="widefat" id="<?php echo $this->get_field_id('category'); ?>" name="<?php echo $this->get_field_name('category'); ?>">
                <option value="">Chọn danh mục</option>
                <?php
                $categories = get_categories();
                foreach ($categories as $cat) {
                    echo '<option value="' . $cat->term_id . '"' . selected($category, $cat->term_id, false) . '>' . $cat->name . '</option>';
                }
                ?>
            </select>
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('post_count'); ?>">Số lượng hiển thị:</label>
            <input class="widefat" id="<?php echo $this->get_field_id('post_count'); ?>" name="<?php echo $this->get_field_name('post_count'); ?>" type="number" min="1" value="<?php echo esc_attr($post_count); ?>">
        </p>
        <?php
    }

    public function update($new_instance, $old_instance) {
        $instance = array();
        $instance['title'] = !empty($new_instance['title']) ? sanitize_text_field($new_instance['title']) : '';
        $instance['category'] = !empty($new_instance['category']) ? absint($new_instance['category']) : '';
        $instance['post_count'] = !empty($new_instance['post_count']) ? absint($new_instance['post_count']) : 5;
        return $instance;
    }
}

function register_crawl_team_sidebar_category_widget() {
    register_widget('Crawl_Team_Sidebar_Category_Widget');
}
add_action('widgets_init', 'register_crawl_team_sidebar_category_widget');
 ?>