<?php 
	class Top_Search_Keywords_Widget extends WP_Widget {
    public function __construct() {
        parent::__construct(
            'top_search_keywords_widget',
            '[Crawl Team] Top từ khóa nổi bật', 
            array('description' => 'Hiển thị danh sách từ khóa được tìm kiếm hàng đầu')
        );
    }

    public function widget($args, $instance) {
        echo $args['before_widget'];
        if (!empty($instance['title'])) {
            echo "<h2>". $args['before_title'] . apply_filters('widget_title', $instance['title']) . $args['after_title'] ."</h2>";
        }

        global $wpdb;
        $table_name = $wpdb->prefix . 'search_keywords';
        $limit = !empty($instance['limit']) ? absint($instance['limit']) : 15;
        $keywords = $wpdb->get_results($wpdb->prepare("SELECT * FROM $table_name ORDER BY count DESC LIMIT %d", $limit));
        
        if (!empty($keywords)) {
            echo '<div class="top-search-keywords">';
            foreach ($keywords as $keyword) {
                $search_url = esc_url(home_url('/?s=' . urlencode($keyword->keyword)));
                echo '<a href="' . $search_url . '">' . esc_html($keyword->keyword) . '</a> ';
            }
            echo '</div>';
        } else {
            echo '<p>No keywords found.</p>';
        }

        echo $args['after_widget'];
    }

    public function form($instance) {
        $title = !empty($instance['title']) ? $instance['title'] : '';
        $limit = !empty($instance['limit']) ? $instance['limit'] : 15;
        ?>
        <p>
            <label for="<?php echo $this->get_field_id('title'); ?>">Tiêu đề:</label>
            <input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo esc_attr($title); ?>">
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('limit'); ?>">Số lượng từ khóa:</label>
            <input class="widefat" id="<?php echo $this->get_field_id('limit'); ?>" name="<?php echo $this->get_field_name('limit'); ?>" type="number" min="1" value="<?php echo esc_attr($limit); ?>">
        </p>
        <?php
    }

    public function update($new_instance, $old_instance) {
        $instance = array();
        $instance['title'] = (!empty($new_instance['title'])) ? sanitize_text_field($new_instance['title']) : '';
        $instance['limit'] = (!empty($new_instance['limit']) && is_numeric($new_instance['limit']) && $new_instance['limit'] > 0) ? absint($new_instance['limit']) : 30;
        return $instance;
    }
}

// Đăng ký widget
function register_top_search_keywords_widget() {
    register_widget('Top_Search_Keywords_Widget');
}
add_action('widgets_init', 'register_top_search_keywords_widget');
?>