<?php
/**
 * Flatsome functions and definitions
 *
 * @package flatsome
 */

require get_template_directory() . '/crawl-team-core/setup.php';
require get_template_directory() . '/inc/init.php';
require get_template_directory() . '/crawl-team-core/query-search.php';
require get_template_directory() . '/crawl-team-core/widget/sidebar-widget.php';
require get_template_directory() . '/crawl-team-core/widget/top-search-widget.php';
require get_template_directory() . '/crawl-team-core/views/post_views.php';
require get_template_directory() . '/crawl-team-core/widget/get-top-movies.php';
require get_template_directory() . '/crawl-team-core/related.php';
require get_template_directory() . '/crawl-team-core/create-table-search.php';
require get_template_directory() . '/crawl-team-core/add-category-image.php';
require get_template_directory() . '/crawl-team-core/add-custom-post-meta-box.php';
require get_template_directory() . '/crawl-team-core/taxonomy.php';
require get_template_directory() . '/crawl-team-core/widget/home-widget.php';
require get_template_directory() . '/crawl-team-core/widget/category-widget.php';

// Get the site URL
$site_url = get_site_url();

// Extract the domain name from the URL
$domain_name = wp_parse_url($site_url, PHP_URL_HOST);

$update_option_data = array(
    'id'           => 'new_id_123456',
    'type'         => 'PUBLIC',
    'domain'       => $domain_name, // Set the domain to the current domain name
    'registeredAt' => '2021-07-18T12:51:10.826Z',
    'purchaseCode' => 'abcd1234-5678-90ef-ghij-klmnopqrstuv',
    'licenseType'  => 'Regular License',
    'errors'       => array(),
    'show_notice'  => false
);

update_option('flatsome_registration', $update_option_data, 'yes');

flatsome()->init();

add_action('init', function() {
    $taxonomies = ['actor', 'director', 'country', 'code'];
    foreach ($taxonomies as $taxonomy) {
        add_filter("rank_math/taxonomy/{$taxonomy}/add_seo_metabox", '__return_true');
    }
}, 999);