<?php
/**
 * Posts content single.
 *
 * @package          Flatsome\Templates
 * @flatsome-version 3.16.0
 */

?>
<div class="entry-content single-page">

	<?php the_content(); ?>

	<?php
	wp_link_pages();
	?>

	<?php if ( get_theme_mod( 'blog_share', 1 ) ) {
		// SHARE ICONS
		echo '<div class="blog-share text-center">';
		echo '<div class="is-divider medium"></div>';
		echo do_shortcode( '[share]' );
		echo '</div>';
	} ?>
</div>

<?php if ( get_theme_mod( 'blog_single_footer_meta', 1 ) ) : ?>
	<footer class="entry-meta text-<?php echo get_theme_mod( 'blog_posts_title_align', 'center' ); ?>">
		<?php
		/* translators: used between list items, there is a space after the comma */
		$category_list = get_the_category_list( __( ', ', 'flatsome' ) );

		/* translators: used between list items, there is a space after the comma */
		$tag_list = get_the_tag_list( '', __( ', ', 'flatsome' ) );


		// But this blog has loads of categories so we should probably display them here.
		if ( '' != $tag_list ) {
			$meta_text = __( 'This entry was posted in %1$s and tagged %2$s.', 'flatsome' );
		} else {
			$meta_text = __( 'This entry was posted in %1$s. Bookmark the <a href="%3$s" title="Permalink to %4$s" rel="bookmark">permalink</a>.', 'flatsome' );
		}

		printf( $meta_text, $category_list, $tag_list, get_permalink(), the_title_attribute( 'echo=0' ) );
		?>
	</footer>
<?php endif; ?>

<div class="crawl-team-categories-tag">
	<h3>Thể loại</h3>
	<div class="row large-columns-4 medium-columns-1 small-columns-1 row-small">
		<?php 
		$categories = get_the_category();
		if (!empty($categories)) {
		    foreach ($categories as $category) {
		        $image_id = get_term_meta($category->term_id, 'category-image-id', true);
		 ?>
			<div class="col post-item">
				<a href="<?php echo esc_url(get_category_link($category->term_id)); ?>">
					<div class="categories-list-item">
						<div class="entry-image">
							<?php 
								if ($image_id) {
						            echo wp_get_attachment_image($image_id, 'thumbnail');
						        }else{
						        	echo '<img src="'.get_template_directory_uri().'/assets/img/default.png" class="no-image" />';
						        }
							?>
						</div>
						<div class="entry-body">
							<?php echo esc_html($category->name); ?>
						</div>
					</div>
				</a>
			</div>
		<?php }
}
 ?>
	</div>
</div>
<div class="crawl-team-categories-tag">
	<h3>Tag</h3>
	<div class="row large-columns-4 medium-columns-1 small-columns-1 row-small">
		<?php 
		$tags = get_the_tags(); // Lấy danh sách tag của bài viết
			if (!empty($tags)) {
				foreach ($tags as $tag) {
		 ?>
			<div class="col post-item">
				<a href="<?php echo esc_url(get_tag_link($tag->term_id)); ?>">
					<div class="categories-list-item">
						<div class="entry-image">
							<?php echo '<img src="'.get_template_directory_uri().'/assets/img/default.png" class="no-image" />'; ?>
						</div>
						<div class="entry-body">
							<?php echo esc_html($tag->name); ?>
						</div>
					</div>
				</a>
			</div>
		<?php } } ?>
	</div>
</div>
    
<?php if ( get_theme_mod( 'blog_author_box', 1 ) ) : ?>
	<div class="entry-author author-box">
		<div class="flex-row align-top">
			<div class="flex-col mr circle">
				<div class="blog-author-image">
					<?php echo get_avatar( get_the_author_meta( 'ID' ), apply_filters( 'flatsome_author_bio_avatar_size', 90 ) ); ?>
				</div>
			</div>
			<div class="flex-col flex-grow">
				<h5 class="author-name uppercase pt-half">
					<?php the_author_meta( 'display_name' ); ?>
				</h5>
				<p class="author-desc small"><?php the_author_meta( 'description' ); ?></p>
			</div>
		</div>
	</div>
<?php endif; ?>


<?php if ( get_theme_mod( 'blog_single_next_prev_nav', 1 ) ) :
	flatsome_content_nav( 'nav-below' );
endif; ?>
<?php
$categories = get_the_category();
if (!empty($categories)) {
    $category_ids = wp_list_pluck($categories, 'term_id');
    $args = array(
        'category__in' => $category_ids,
        'post__not_in' => array(get_the_ID()),
        'posts_per_page' => 12,
        'orderby' => 'rand',
    );
    $related_posts = new WP_Query($args);
    if ($related_posts->have_posts()) :
    $post_quality = get_post_meta( get_the_ID(), '_post_quality', true ); ?>
        <div class="crawl-team-related-movie">
            <h4 class="h2">Xem thêm</h4>
            <div class="row large-columns-4 medium-columns-1 small-columns-1 row-small" id="related-posts-container">
                <?php while ($related_posts->have_posts()) : $related_posts->the_post(); ?>
                    <div class="col post-item">
                        <div class="col-inner">
                            <div class="box box-normal box-text-bottom box-blog-post has-hover">
                            	<?php if (!empty($post_quality)) { ?>
                                <span class="post_quality"><?php echo $post_quality; ?></span>
                            <?php } ?>
                                <div class="box-image" style="border-radius:1%;">
                                    <div class="image-cover" style="padding-top:56%;">
                                        <a href="<?php the_permalink(); ?>" class="plain" aria-label="<?php the_title(); ?>">
                                            <?php if (has_post_thumbnail()) : ?>
                                                <img decoding="async" src="<?php echo get_the_post_thumbnail_url(get_the_ID(), 'medium'); ?>" class="attachment-medium size-medium wp-post-image" alt="<?php the_title(); ?>">
                                            <?php endif; ?>
                                        </a>
                                    </div>
                                </div>
                                <div class="box-text text-left is-small dark">
                                    <div class="box-text-inner blog-post-inner">
                                        <h5 class="post-title is-large">
                                            <a href="<?php the_permalink(); ?>" class="plain"><?php the_title(); ?></a>
                                        </h5>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endwhile; ?>
            </div>
            <?php if ($related_posts->max_num_pages > 1) : ?>
            	<div class="text-center">
            		<button id="load-more-posts" class="button" data-page="1" data-category-ids="<?php echo esc_attr(json_encode($category_ids)); ?>" data-exclude-post="<?php echo esc_attr(get_the_ID()); ?>">Xem thêm</button>
            	</div>
            <?php endif; ?>
        </div>
        <?php wp_reset_postdata(); ?>
    <?php endif; ?>
<?php } ?>

<script>
jQuery(document).ready(function($) {
    $('#load-more-posts').on('click', function() {
        var button = $(this);
        var page = parseInt(button.data('page')) + 1;
        var category_ids = button.data('category-ids') || [];
        var exclude_post = button.data('exclude-post') || 0;

        if (!category_ids || !exclude_post) {
            console.error('Missing category_ids or exclude_post');
            return;
        }

        $.ajax({
            url: '<?php echo admin_url('admin-ajax.php'); ?>',
            type: 'POST',
            data: {
                action: 'load_more_related_posts',
                category_ids: JSON.stringify(category_ids),
                exclude_post: exclude_post,
                page: page,
                posts_per_page: 8,
                nonce: '<?php echo wp_create_nonce('load_more_related_posts_nonce'); ?>'
            },
            beforeSend: function() {
                button.addClass('loading');
            },
            success: function(response) {
                if (response.success && response.data.posts) {
                    $('#related-posts-container').append(response.data.posts);
                    button.data('page', page);
                    if (!response.data.has_more) {
                        button.remove();
                    }
                } else {
                    button.remove();
                }
                button.removeClass('loading');
            },
            error: function(xhr) {
                console.error('AJAX error:', xhr.responseText);
                button.removeClass('loading');
            }
        });
    });
});
</script>
