<?php
/**
 * Post-entry title.
 *
 * @package          Flatsome\Templates
 * @flatsome-version 3.16.0
 */

if ( is_single() ) :
	if ( get_theme_mod( 'blog_single_header_title', 1 ) ) :
		echo '<div class="crawl-team-single-header"><h1 class="entry-title">' . get_the_title() . '</h1>';
		?>
		<?php 
			$actors = get_the_terms( get_the_ID(), 'actor' );
			$codes = get_the_terms( get_the_ID(), 'code' );
			if ( $actors && ! is_wp_error( $actors ) ) {
			    foreach ( $actors as $actor ) {
			        echo "<a href='". esc_url(get_tag_link($actor->term_id)) ."'>". $actor->name ."</a> ";
			    }
			}

			if ( $codes && ! is_wp_error( $codes ) ) {
			    foreach ( $codes as $code ) {
			        echo "<a href='". esc_url(get_tag_link($code->term_id)) ."'>". $code->name ."</a> ";
			    }
			}

		echo "</div>";
		?>
	<?php
	endif;
else :
	echo '<h2 class="entry-title"><a href="' . get_the_permalink() . '" rel="bookmark" class="plain">' . get_the_title() . '</a></h2>';
endif;
?>

